﻿using System.ComponentModel;
using System.Web.UI;

namespace Framework.Web.UI
{
    [DefaultProperty("LTextKey")]
    [ToolboxData("<{0}:LLabel runat=server></{0}:LLabel>")]
    public class LLabel : System.Web.UI.WebControls.Label, ILocalizeControl
    {
        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey
        {
            get { return _ltextKey; }
            set { _ltextKey = value; }
        }
        private string _ltextKey = string.Empty;


        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
